<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Semestre extends Model
{
    use HasFactory;

    protected $table = 'semestres';
    // Especificar la clave primaria si no es 'id'
    protected $primaryKey = 'id';
    protected $fillable = [
        'nombre',
        'descripcion',
        'activo',
        'fecha_creacion',
    ];

    public function cursos()
    {
        return $this->hasMany(Curso::class);
    }

    public function matriculas()
    {
        return $this->hasMany(Matricula::class);
    }
}
