<!-- Modal centrado -->
<div class="modal fade" id="modalOferta{{ $oferta->id_oferta }}" tabindex="-1" aria-labelledby="modalLabel{{ $oferta->id_oferta }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalLabel{{ $oferta->id_oferta }}">{{ $oferta->titulo }}</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <!-- Columna izquierda -->
                    <div class="col-md-6">
                        <p><strong>Empresa:</strong> {{ $oferta->empresa->nombre_empresa ?? 'Empresa desconocida' }}</p>
                        <p><strong>Fecha de Publicación:</strong> {{ \Carbon\Carbon::parse($oferta->fecha_publicacion)->format('d/m/Y') }}</p>
                        <p><strong>Fecha Límite:</strong> {{ $oferta->fecha_limite ? \Carbon\Carbon::parse($oferta->fecha_limite)->format('d/m/Y') : 'No especificada' }}</p>
                        <p><strong>Lugar:</strong> {{ $oferta->lugar ?? 'No especificado' }}</p>
                        <p><strong>Tipo de Contrato:</strong> {{ $oferta->tipoContrato->nombre_tipo_contrato ?? 'No definido' }}</p>
                        <p><strong>Tipo de Oferta:</strong> {{ $oferta->tipo_oferta ?? 'No especificado' }}</p>
                        <p><strong>Remuneración:</strong> {{ $oferta->remuneracion ? 'S/ ' . number_format($oferta->remuneracion, 2) : 'No especificada' }}</p>
                        <p><strong>Vacantes:</strong> {{ $oferta->vacantes ?? 'No especificado' }}</p>
                        <p><strong>Estado:</strong> 
                            @switch($oferta->estado)
                                @case('aceptado') <span class="badge bg-success">Aceptado</span> @break
                                @case('pendiente') <span class="badge bg-warning text-dark">Pendiente</span> @break
                                @case('rechazado') <span class="badge bg-danger">Rechazado</span> @break
                                @default <span class="badge bg-secondary">Desconocido</span>
                            @endswitch
                        </p>
                        @if ($oferta->archivo_pdf && file_exists(public_path($oferta->archivo_pdf)))
                            <a href="{{ asset($oferta->archivo_pdf) }}" target="_blank" class="btn btn-outline-info btn-sm mt-2">
                                Ver Documento PDF <i class="fas fa-file-pdf ms-1"></i>
                            </a>
                        @endif
                    </div>

                    <!-- Columna derecha -->
                    <div class="col-md-6">
                        <p><strong>Experiencia:</strong></p>
                        <div class="border p-2 rounded bg-light mb-3" style="min-height: 100px;">
                            {!! nl2br(e($oferta->experiencia ?? 'No especificado')) !!}
                        </div>

                        <p><strong>Requisitos:</strong></p>
                        <div class="border p-2 rounded bg-light mb-3" style="min-height: 100px;">
                            {!! nl2br(e($oferta->requisitos ?? 'No especificado')) !!}
                        </div>

                        <p><strong>Pasos para Postular:</strong></p>
                        <div class="border p-2 rounded bg-light" style="min-height: 100px;">
                            {!! nl2br(e($oferta->pasos_postular ?? 'No especificado')) !!}
                        </div>
                    </div>
                </div>
            </div>

           @php
    $curriculumPath = $postulante?->curriculum_archivo;
@endphp

<div class="modal-footer">
    @if (!empty($curriculumPath))
        <button class="btn btn-success btn-postular" data-id="{{ $oferta->id_oferta }}">
            <i class="fas fa-paper-plane me-1"></i> Postular
        </button>
    @else
        <button class="btn btn-secondary" disabled>
            <i class="fas fa-ban me-1"></i> No puedes postular sin haber subido tu currículum
        </button>
    @endif

    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cerrar</button>
</div>




        </div>
    </div>
</div>
